/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.editor.findbar.impl.FindBarDecorator;
import java.util.HashSet;
import java.util.Set;

public class FindBarVisibilityControl {
    private final Set<FindBarDecorator> decs = new HashSet<FindBarDecorator>();
    private boolean visible = false;

    public void register(FindBarDecorator findBarDecorator) {
        if (this.visible) {
            findBarDecorator.showFindBar(false);
        }
        this.decs.add(findBarDecorator);
    }

    public void unregister(FindBarDecorator findBarDecorator) {
        this.decs.remove(findBarDecorator);
    }

    public void setVisible(boolean enable, FindBarDecorator requester, String selectedFindText) {
        try {
            if (enable) {
                if (!this.visible) {
                    FindBarDecorator.updateFromEclipseFindSettings();
                }
                if (selectedFindText != null) {
                    requester.setFindText(selectedFindText);
                }
                for (FindBarDecorator d : this.decs) {
                    if (d != requester) continue;
                    d.showFindBar(true);
                }
            } else {
                for (FindBarDecorator d : this.decs) {
                    if (d != requester) continue;
                    d.hideFindBar(true);
                }
            }
        }
        finally {
            this.visible = enable;
        }
    }
}

